
% Function that gives visual or auditory stimuli.
% Written by A. Znon
% The freely available Cogent Toolbox is necessary



DISPLAY_PARAMETERS{1} = 1; %Full screen mode
DISPLAY_PARAMETERS{2} = 3; %1024/768
DISPLAY_PARAMETERS{3} = [0 0 0]; %Background color
DISPLAY_PARAMETERS{4} = [1 1 1]; %Foreground color
DISPLAY_PARAMETERS{5} = 'Arial'; %Font
DISPLAY_PARAMETERS{6} = round(110/3.5); %Letter size
DISPLAY_PARAMETERS{7} = 10; %buffer number

FREQ = 440;
DURATION = 1/FREQ;
LL = 22050*DURATION;
REP = 100;
SINEWAVE = sin([0:(2*pi)/LL:2*pi*REP])';

config_display(DISPLAY_PARAMETERS{1} , DISPLAY_PARAMETERS{2}, DISPLAY_PARAMETERS{3}, DISPLAY_PARAMETERS{4}, DISPLAY_PARAMETERS{5}, DISPLAY_PARAMETERS{6}, DISPLAY_PARAMETERS{7});
config_keyboard(100,  5, 'nonexclusive');
% config_serial(1, 115200, 0, 0, 8);
CONFIG_SOUND( 1, 16, 22050, 10 )
start_cogent;

gsd = cggetdata('gsd');
resolution.x = gsd.ScreenWidth;
resolution.y = gsd.ScreenHeight;

cd F:\MATLABwork\eNTERFACE\images;
a=dir;
ImageList = randperm(length(a)-2);
ImageIndx = 0;

cd F:\MATLABwork\eNTERFACE\Sounds;
b=dir;
SoundList = randperm(length(b)-2);
SoundIndx = 0;

Keys = [];
wait(8000);
preparestring('READY', 1);
drawpict(1);
wait(1000);
clearpict(1);
cgflip;
while (all(Keys ~= 1)) | isempty(Keys)
    [kd, KD] = cgkeymap;
    
    if any(KD)
        Keys = [Keys, find(KD)];
        
        switch Keys(end)
            case 16 %a
                PREPAREPURETONE( 660, 1000, 2 );
                playsound(2);
            case 17 %z
                PREPAREPURETONE( 880, 1000, 2 );
                playsound(2);
            case 18 %e
                cd F:\MATLABwork\eNTERFACE\Sounds;
                SoundIndx = SoundIndx+1;
                if SoundIndx>length(SoundList)
                    SoundIndx=1;
                end
                loadsound(b(2+SoundList(SoundIndx)).name, 2);
                playsound(2);
            case 19 %r
                cd F:\MATLABwork\eNTERFACE\images;
                ImageIndx = ImageIndx+1;
                if ImageIndx>length(ImageList)
                    ImageIndx=1;
                end
                loadpict(a(2+ImageList(ImageIndx)).name, 1);
                drawpict(1);
                wait(1000);
                clearpict(1);
                cgflip;
            case 20 %t
            case 21 %y
        end
    end
    
    
   
end
Keys;


% preparesound(SINEWAVE, 1);
% PREPAREPURETONE( 440, 1000, 2 );
% wait(10000);
% loopsound(2);
% wait(10000);
% stopsound(2);

stop_cogent;